/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.wsrr;

import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.admin.resources.VWResource;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class VWConfigWSRRCustomPropertiesTableModel
extends AbstractTableModel {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_VALUE = 1;
    protected String m_dialogTitle = null;
    private VWSession m_session = null;
    private Vector m_rowData = null;
    private boolean m_bHasChanged = false;
    private String[] m_columnName = new String[]{VWResource.Name, VWResource.Value};

    public VWConfigWSRRCustomPropertiesTableModel(VWSession session, String[] customPropertiesList) {
        try {
            this.m_session = session;
            this.initRows(customPropertiesList);
            this.m_dialogTitle = VWIDMBaseFactory.instance().getVWString(4).toString();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void initRows(String[] customPropertiesList) {
        this.m_rowData = new Vector();
        if (customPropertiesList != null) {
            for (int i = 0; i < customPropertiesList.length; i += 2) {
                String aName = customPropertiesList[i];
                String aValue = customPropertiesList[i + 1];
                String[] newParameter = null;
                newParameter = new String[]{aName, aValue};
                this.m_rowData.addElement(newParameter);
            }
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: 
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return this.m_columnName.length;
    }

    public String getColumnName(int nColumn) {
        switch (nColumn) {
            case 0: {
                return VWResource.Name;
            }
            case 1: {
                return VWResource.Value;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            if (this.m_rowData == null) {
                return null;
            }
            String[] aProp = (String[])this.m_rowData.elementAt(nRowIndex);
            if (aProp == null) {
                return null;
            }
            switch (nColumnIndex) {
                case 0: {
                    if (aProp != null) {
                        return aProp[0];
                    }
                    return "";
                }
                case 1: {
                    if (aProp != null) {
                        return aProp[1];
                    }
                    return "";
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRow, int nColumn) {
        return false;
    }

    public void releaseResources() {
        this.m_dialogTitle = null;
        if (this.m_rowData != null) {
            this.m_rowData.removeAllElements();
            this.m_rowData = null;
        }
    }
}

